import csv
import pandas
import smtplib
from docxtpl import DocxTemplate
from docx2pdf import convert
from mail import send_email
from tkinter import messagebox


def excel_to_csv_to_list_dicts(name_file, n):
    file = pandas.read_excel(name_file)  # считывание данных из excel
    file.to_csv(name_file.split('.')[0] + '.csv')  # конвертация в csv
    with open(name_file.split('.')[0] + '.csv', encoding="utf8") as csvfile:
        reader = csv.reader(csvfile, delimiter=';', quotechar='"')
        context = []
        for index, row in enumerate(reader):
            row = row[0].split(',')
            if index > n:
                break
            if index == 0:
                keys = row
            else:
                d = {}
                for i in range(len(keys)):
                    d[keys[i]] = row[i]
                context.append(d)
    return keys, context


def autofill(name_file, new_file, keys, context, check):
    for i in range(len(context)):
        doc = DocxTemplate(name_file)  # подключение шаблона
        doc.render(context[i])  # заполнение шаблона
        doc.save(f"{context[i][keys[0]]}{context[i][keys[1]]}.docx")  # сохранение шаблона
        if check:
            convert(f"{context[i][keys[0]]}{context[i][keys[1]]}.docx", new_file)  # конвертация шаблона в pdf


def sending_by_mail(context, keys, answer, new_file, login, password, tema, text):
    if answer:
        for i in range(len(context)):
            files = f'{new_file}\\{context[i][keys[0]]}{context[i][keys[1]]}.pdf'  # строка с путем к файлу
            addr_to = context[i]['email'].strip()  # считывание почты адресата
            try:
                send_email(addr_to, files, login, password, tema, text) # отправка письма с вложением
            except smtplib.SMTPRecipientsRefused:
                messagebox.showerror('Ошибка', f'Почта {context[i]["email"]} строка {i} не найдена.')