from tkinter import *
from text import *
from tkinter import messagebox
import smtplib

tk = Tk()
tk.title('Auto')
tk.geometry('520x700+500+10')
tk.resizable(0, 0)
name_file = StringVar()
exlab = Label(tk, text='Введите путь к excel файлу:', font="Arial 10")
excel = Entry(tk, width=20, bd=3, textvariable=name_file)
count = StringVar()
exlab.grid(row=0, column=1, padx=30, pady=0)
excel.grid(row=0, column=2)
amount = Entry(tk, width=7, bd=3, textvariable=count)
amlab = Label(tk, text='Введите кол-во строк:', font='Arial 10')
amlab.grid(row=1, column=1, padx=30, pady=5)
amount.grid(row=1, column=2)

temp_file = StringVar()
template = Entry(tk, width=20, bd=3, textvariable=temp_file)
templab = Label(tk, text='Введите путь к шаблону:', font="Arial 10")
templab.grid(row=2, column=1, padx=30, pady=5)
template.grid(row=2, column=2)

save_file = StringVar()
save = Entry(tk, width=20, bd=3, textvariable=save_file)
slab = Label(tk, text='Введите место, куда сохранять файл:', font='Arial 10')
slab.grid(row=3, column=1, padx=30, pady=5)
save.grid(row=3, column=2)
convertation1 = IntVar()
mail1 = IntVar()
convertation = Checkbutton(tk, text='Конвертация в PDF.', variable=convertation1, onvalue=1, offvalue=0)
mail = Checkbutton(tk, text='Отправлять письмо(а)?', variable=mail1, onvalue=1, offvalue=0)
convertation.grid(row=4, column=1, padx=30, pady=5)
mail.grid(row=5, column=1, padx=30, pady=5)

login_text = StringVar()
login = Entry(tk, width=20, bd=3, textvariable=login_text)
loglab = Label(tk, text='Введите логин:', font='Arial 10')
loglab.grid(row=6, column=1, padx=30, pady=5)
login.grid(row=6, column=2)

password_text = StringVar()
password = Entry(tk, width=20, bd=3, show='*', textvariable=password_text)
passlab = Label(tk, text='Введите пароль:', font='Arial 10')
passlab.grid(row=7, column=1, padx=30, pady=5)
password.grid(row=7, column=2)

tema_text = StringVar()
tema = Entry(tk, width=20, bd=3, textvariable=tema_text)
temalab = Label(tk, text='Введите тему сообщения:', font="Arial 10")
temalab.grid(row=8, column=1, padx=30, pady=5)
tema.grid(row=8, column=2)

text = Text(tk, width=25, bd=3, wrap=WORD)
textlab = Label(tk, text='Введите текст сообщения:', font='Arial 10')
textlab.grid(row=9, column=1, padx=15, pady=5)
text.grid(row=9, column=2)


def main():
    messagebox.showinfo('Запуск', 'Нажмите ОК, чтобы запустить процесс')
    try:
        text_message = text.get('1.0', 'end')
        keys, context = excel_to_csv_to_list_dicts(name_file.get(), int(count.get()))
        autofill(temp_file.get(), save_file.get(), keys, context, bool(convertation1.get()))
        sending_by_mail(context, keys, bool(mail1.get()), save_file.get(),
                        login_text.get(), password_text.get(), tema_text.get(), text_message)
        messagebox.showinfo('Завершение', 'Процесс завершился успешно')
        tk.destroy()
    except FileNotFoundError:
        messagebox.showerror('Ошибка', 'Указанный файл/путь не найден')
    except smtplib.SMTPAuthenticationError:
        messagebox.showerror('Ошибка', 'Логин/пароль неверны или не установлены настройки почты')
    except ValueError:
        messagebox.showerror('Ошибка', 'Количество строк введите цифрами!')


ok = Button(tk, text='OK', command=main)
ok.grid(row=10, column=2)
tk.mainloop()